class Prvek:
    def __init__( self, x, dalsi ):
        self.x = x
        self.dalsi = dalsi

class LSS:
    def __init__(self):
        self.zac = None
        self.kon = None

    def Vytiskni(self):
        p = self.zac
        print( "LSS:", end=" " )
        while p is not None:
            print( p.x, end=" " )
            p = p.dalsi
        print(".")

    def PridejNaZacatek(self,x):
        self.zac = Prvek(x,self.zac)
        if self.kon is None:
            self.kon = self.zac

    def PripojNaKonec(self, prvek):
        if self.kon is None:
            # seznam je prazdny
            self.zac = prvek
            self.kon = prvek
        else:
            # pripoj Prvek na konec
            self.kon.dalsi = prvek
            prvek.dalsi = None
            self.kon = prvek

    def VymazPrvniPrvek(self):
        if self.zac is None:
            # seznam je prazdny -> nedelej nic
            return
        self.zac = self.zac.dalsi
        if self.zac is None:
            self.kon = None

    def PridejNaKonec(self,x):
        if self.zac is None:
            self.PridejNaZacatek(x)
        else:
            # moznost A: prochazeni
            # p = self.zac
            # while p.dalsi!=None:
            #     p = p.dalsi

            # moznost B: pamatujeme si
            p = self.kon
            # ...a pripojit:
            p.dalsi = Prvek(x,None)
            self.kon = p.dalsi

    def VymazPosledniPrvek(self):
        #if self.zac.dalsi==None:
        if self.zac is self.kon:
            self.VymazPrvniPrvek()
        else:
            p = self.zac
            while p.dalsi.dalsi!=None:
                p = p.dalsi
            p.dalsi = None
            self.kon = p


    def VymazHodnotu(self, hodnota_ke_smazani):
        p = self.zac
        predchudce_p = None

        while p is not None and p.x != hodnota_ke_smazani:
            # jdi na dalsi
            predchudce_p = p
            p = p.dalsi
        
        if p is None:
            return # hodnota nenalezena
        else:
            if predchudce_p is None:
                # p je prvni prvek
                self.VymazPrvniPrvek()
            else:
                predchudce_p.dalsi = p.dalsi

def Zip(lss1, lss2):
    """Vrati "zip" (prolozeni) obou seznamu, NErozbije ty puvodni.
    Pokud seznamy nejsou stejne dlouhe, zpracuje jen spolecny zacatek."""
    p1 = lss1.zac
    p2 = lss2.zac
    vysledek = LSS()

    while p1 is not None and p2 is not None:
        vysledek.PridejNaKonec(p1.x)
        vysledek.PridejNaKonec(p2.x)

        p1 = p1.dalsi
        p2 = p2.dalsi
    return vysledek


def ZipDestructive(lss1, lss2):
    """Vrati "zip" (prolozeni) obou seznamu, ROZBIJE ty puvodni.
    Pokud seznamy nejsou stejne dlouhe, zpracuje jen spolecny zacatek."""
    p1 = lss1.zac
    p2 = lss2.zac
    vysledek = LSS()

    while p1 is not None and p2 is not None:
        # zapamatujeme si dalsi prvek, drive nez ten aktualni rozbijeme
        p1_dalsi = p1.dalsi
        p2_dalsi = p2.dalsi

        vysledek.PripojNaKonec(p1)
        vysledek.PripojNaKonec(p2)

        p1 = p1_dalsi
        p2 = p2_dalsi
    return vysledek


def NactiLSS():
    """Nacteni ze vstupu - jako sablona v ReCodExu."""
    seznam = LSS()

    r = input()
    while r!="":
        radek = r.split()
        if len(radek)==0:
            break
        for s in radek:
            seznam.PridejNaKonec(int(s))
        r = input()
    return seznam

def NactiLSSZeSeznamu(list_):
    """Nacteni z Python listu."""
    seznam = LSS()
    for x in list_:
        seznam.PridejNaKonec(x)
    return seznam
            


            
# NactiLSS().Vytiskni()
# vstupni_data = [1,2,3,4]
# lss = NactiLSSZeSeznamu(vstupni_data)
# lss.Vytiskni()
# lss.VymazHodnotu(2)
# lss.Vytiskni()

lss1 = NactiLSSZeSeznamu([1,2,3])
lss2 = NactiLSSZeSeznamu(['a','b','c', 'd', 'e'])

# vysledek = Zip(lss1,lss2)
vysledek = ZipDestructive(lss1,lss2)

vysledek.Vytiskni()

# v pripade pouziti ZipDestructive se puvodni seznamy nezachovaji,
# v pripade pouziti Zip se zachovaji v puvodni podobe
lss1.Vytiskni()
lss2.Vytiskni()