import time


class Heap:
    def __init__(self, items):
        self._heap = [items[0]]
        for item in items[1:]:
            self.insert(item)
    
    def insert(self, item):
        def parrent(i):
            return (i-1)//2

        self._heap.append(item)
        i = len(self._heap)-1
        while i > 0 and self._heap[i] < self._heap[parrent(i)]:
            self._heap[i], self._heap[parrent(i)] = self._heap[parrent(i)], self._heap[i]
            i = parrent(i)

    def extract_min(self):
        min_ = self._heap[0]
        self._heap[0] = self._heap[-1]
        del self._heap[-1]
        i = 0

        def greater_and_both_exist(i1,i2):
            """If both i1 and i2 are valid indices to heap, return i1 > i2. If at least one of them is invalid, return False.
            """
            return i2 < len(self._heap) and i1 < len(self._heap) and self._heap[i1]>self._heap[i2]

        def left_child(i):
            return 2*i+1

        def right_child(i):
            return 2*i+2

        while greater_and_both_exist(i, left_child(i)) or greater_and_both_exist(i, right_child(i)):
            # se kterým prohodit? - otázka na všechny, rozebrat
            # např. s levým pokud je menší než i, jinak pravým nestačí - levý mohl být větší než pravý -> nutno prohodit s minimem
            
            min_child = right_child(i) if greater_and_both_exist(left_child(i), right_child(i)) else left_child(i)

            self._heap[i], self._heap[min_child] = self._heap[min_child], self._heap[i]
            i= min_child

        return min_

    def is_empty(self):
        return len(self._heap) == 0


class MinList:
    def __init__(self, items):
        self._items = [i for i in items]
        # self._items = items

    def extract_min(self):
        min_ = min(self._items)
        self._items.remove(min_)
        return min_

    def is_empty(self):
        return len(self._items) == 0





def sort(items):
    # ds = MinList(items)
    ds = Heap(items)
    sorted_items = []
    while not ds.is_empty():
        min = ds.extract_min()
        sorted_items.append(min)
    return sorted_items


def read_from_std_input():
    items = []
    x = int(input())
    while x != -1:
        items.append(x)
        x = int(input())
    return items

# items = [3,4,1,2,5]
# items = (3,4,1,2,5)
items = read_from_std_input()


start_time = time.perf_counter()
sorted_items = sort(items)
run_time = time.perf_counter() - start_time
print("Sorted:", sorted_items)
print("Sorting took", run_time, "seconds")
# print("Original input:", items)
