

class Stack:

    def __init__(self):
        self.__items = []

    def push(self, value):
        """Vloz value na vrsek zasobniku."""
        self.__items.append(value)

    def pop(self):
        """Odeber a vrat hodnotu z vrsku."""
        return self.__items.pop()

    def peek(self):
        """Vrat hodnotu na vrsku, ale neodeber."""
        return self.__items[-1]
    
    def is_empty(self):
        """Vrat True/False, zda je prazdny."""
        return len(self.__items) == 0

    def __len__(self):
        """Vrat pocet prvku. Umoznute pouziti len(...)"""
        return len(self.__items)

    def __repr__(self):
        """Vrat textovou reprezentaci tridy - co se vypise v print(..)"""
        # Chceme vratit string ve tvaru "Stack: 1, 2, 3"
        return "Stack: " + ", ".join([ repr(i) for i in self.__items])



if __name__ == "__main__": # True jen pokud jsem spustil prave tento soubor.

    # Pouziti:

    s = Stack()
    # Vloz 1,2,3
    s.push(1)
    s.push(2)
    s.push(3)

    # Odeber a vypis cislo na vrchu zasobniku
    # print(s.pop())
    # print("Pocet", len(s))
    # print(s.pop())
    # print("Pocet", len(s))

    # Vypis obsah
    print(s)
    l = [1,2,3]
    print(l)

