class Person:
    def __init__(self, name, surname):
        self._name = name
        self._surname = surname

    def __str__(self):
        return self._name + " " + self._surname

    def __repr__(self):
        return f"Person(name={self._name}, surname={self._surname})"

if __name__ == "__main__":
    p = Person("Jakub", "Mestek")
    print(str(p))  # > "Jakub Mestek"
    print(repr(p)) # > "Person(name=Jakub, surname=Mestek)"
    print(p)       # > "Jakub Mestek"