
class Node:
    def __init__(self, data, left, right):
        self.data = data
        self.left = left
        self.right = right

def create_tree():
    """Returns root node of the tree from slides."""
    n4 = Node(4, None, None)
    n3 = Node(3, None, n4)
    n2 = Node(2, n3, None)
    n9 = Node(9, None, None)
    n8 = Node(8, None, n9)
    n7 = Node(7, None, None)
    n6 = Node(6, n7, n8)
    n1 = Node(1, n2, n6)
    return n1

def create_tree_v2():
    """Returns root node of the tree from slides."""
    return Node(
        1, 
        Node(
            2, 
            Node(3, None, Node(4, None, None)), 
            None), 
        Node(
            6, 
            Node(7, None, None), 
            Node(8, None, Node(9, None, None))))


def read_from_file(filepath):

    key_to_node = {}

    def get_node(key):
        if key == "":
            return None
        elif key in key_to_node:
            return key_to_node[key]
        else:
            node = Node(key, None, None)
            key_to_node[key] = node
            return node

    with open(filepath, 'r') as f:
        root_key = f.readline().strip()

        line = f.readline().strip()
        while line != "":
            parent_key, children = line.split("->")
            left_key, right_key = children.split(",")
            
            parent_node = get_node(parent_key.strip())
            left_node = get_node(left_key.strip())
            rigth_node = get_node(right_key.strip())
            parent_node.left = left_node
            parent_node.right = rigth_node

            line = f.readline().strip()

    return key_to_node[root_key]


def height(node):
    """Computes height of a tree which the node is root of."""
    if node is None:
        return -1 # trik
    else:
        return 1 + max(height(node.left), height(node.right))


def _check_symmetry(left_node, right_node):
    if left_node is None and right_node is None:
        return True
    if left_node is not None and right_node is not None:
        return (
            left_node.data == right_node.data 
            and _check_symmetry(left_node.left, right_node.right)
            and _check_symmetry(left_node.right, right_node.left)
        )
    else:
        return False

def is_symmetric(tree):
    return _check_symmetry(tree.left, tree.right)

if __name__ == "__main__":
    tree = create_tree_v2()
    # tree = read_from_file("09/tree1.txt")
    # print(height(tree))
    print(is_symmetric(tree))
    symmetric_tree = Node(1, 
                        Node(2, Node(3,None,None),None),
                        Node(2, None, Node(3, None, None)))
    
    # print(is_symmetric(symmetric_tree))





