
# Čtení prvního řádku
file = open("10/in.txt")
line = file.readline()
line = line.strip()
print(line)
file.close()

# with - automaticky soubor zavře
with open("10/in.txt") as file:
    line = file.readline()
    line = line.strip()
    print(line)

# čtení všech řádků najednou do listu
with open("10/in.txt") as file:
    lines = file.readlines()
    print(lines)

# Odbočka - jak funguje strip() - odstranění whitespace ze začátku a konce stringu
s = "   ah o j     "
s2 = s.strip() #= "ah o j"
print(s)
print(s2)

# Čtení všech řádků, ale po jednom
with open("10/in.txt") as file:
    line = file.readline().strip()
    while line != "":
        print(line)
        line = file.readline().strip()

# Jiný (kratší) způsob
with open("10/in.txt") as file:
    for line in file:
        print(line.strip())

# Pozor na kódování
with open("10/in_cz.txt") as file:
    line = file.readline()
    line = line.strip()
    print(line)

with open("10/in_cz.txt", encoding="utf8") as file:
    line = file.readline()
    line = line.strip()
    print(line)


# Zápis do souboru
out_file = open("out.txt", "w")
out_file.write("123\n") # pozor, odřádkovat si musíme sami
out_file.write("456\n")
out_file.close()

# Zápis pomocí with, ať nemusíme zavírat
# Druhý parametr funkce open: "w" - otevření pro zápis (smaže původní obsah), "a" - append (zachová původní obsah, nové řádky zapisuje pod)
with open("out.txt", "a", encoding="utf8") as out_file:
    out_file.write("123\n")
    out_file.write("456\n")

    print("hello", file=out_file) # print(..) zapisující do souboru místo do terminálu
    print("hello", file=out_file)
    print("česky", file=out_file)



# Výpis vlastního objektu

class Prvek:
    def __init__(self):
        self.a = 45
    def __str__(self):
        return str(self.a)


out_file = open("out.txt", "w")
i = Prvek()
# i = "ahoj"
try:
    out_file.write(i)
    # print(i, file=out_file)
except TypeError: # file.write(...) bere jen string, pokud předáme něco jiného, vyhodí chybu
    print("Chyba - parametr není string")

print(i, file=out_file) # print nejprve zavolá str(i) -> nevyhazuje error
out_file.close()