def naslednici(stav):
    x, y = stav
    tahy = [(-1,2),(1,2),(2,1),(2,-1),(1,-2),(-1,-2),(-2,1),(-2,-1)]
    naslednici = []
    for dx, dy in tahy:
        nx, ny = x+dx, y+dy
        if (0<=nx<8) and (0<=ny<8):
            naslednici.append((nx,ny))

    return naslednici


def prohledej(pocatecni_stav, cilovy_stav):
    """Implementace BFS pro hledání cesty z počátečního stavu do cílového.
    Vrací seznam mezistavů (= políček přes která musíme projít)."""

    vzdalenost = {pocatecni_stav: 0} # klice jsou objevene stavy, hodnota je vzdalenost daneho stavu od pocatecniho_stavu
    k_prozkoumani = [pocatecni_stav] # fronta
    predchudci = {} # z jakeho policka jsem se na dane policko dostal

    while k_prozkoumani:
        stav = k_prozkoumani.pop(0) # vyber prvni ze fronty
        if stav == cilovy_stav:
            # nalezen cil
            return rekonstruuj_cestu(pocatecni_stav, cilovy_stav, predchudci)
        for naslednik in naslednici(stav):
            if naslednik not in vzdalenost:
                vzdalenost[naslednik] = vzdalenost[stav] + 1
                predchudci[naslednik] = stav
                k_prozkoumani.append(naslednik) # přidej do fronty

    return None # cesta na cilove policko neexistuje

def rekonstruuj_cestu(pocatecni_stav, cilovy_stav, predchudci):
    cesta = []
    v = cilovy_stav
    while v != pocatecni_stav:
        cesta.append(v)
        v = predchudci[v]
    
    cesta.reverse()
    return cesta

cesta = prohledej((1,3), (7,7))
print(cesta) # [(2, 5), (3, 7), (5, 6), (7, 7)]