

def polorovina(u,v,x):
    """v jake polorovine vuci primce uv lezi x? Vraci 1, -1, nebo 0 (= lezi na primce uv)"""

    # TRIK: pouzijeme determinant matice uv, vx - viz Lin. algebra - pravo/levotocivost baze
    # POZN: slo by to zjistit i jinak, napr. dosazenim x do obecne rovnice primky uv

    uv = (v[0]-u[0], v[1]-u[1])
    vx = (x[0]-v[0], x[1]-v[1])

    vysledek = uv[0]*vx[1] - uv[1]*vx[0]

    # zaokrouhli vysledek na {+1, 0, -1}
    if vysledek<0:
        return -1
    elif vysledek > 0:
        return 1
    else:
         return 0

# zkontroluj C, D vuci AB
def oba_body_v_ruznych(u,v,x,y):
    """zjisti, zda body x a y lezi v ruznych polorovinach vuci usecce uv nebo alepson jeden z nich lezi na uv"""
    polorovina_x = polorovina(u,v,x)
    polorovina_y = polorovina(u,v,y)

    return polorovina_x != polorovina_y or polorovina_x == 0

def lezi_na_usecce(u,v,x):
    """vrat, zda bod x lezi na usecce uv"""
    if polorovina(u,v,x) != 0:
        return False # nelezi ani na primce uv
    else:
        return u[0] <= x[0] <= v[0] and u[1] <= x[1] <= v[1]

def maji_spolecny_bod(a,b,c,d):
    # myslenka: usecky maji spolecny bod <=> 
    # pro obe usecky plati, ze jeji koncove body lezi v opacnych polorovinach
    # vuci te druhe usecce

    if polorovina(a,b,c) == polorovina(a,b,d) == 0:
        # obe usecky na 1 primce
        if (lezi_na_usecce(a,b,c) or
            lezi_na_usecce(a,b,d) or
            lezi_na_usecce(c,d,a) or
            lezi_na_usecce(c,d,b)):
            return True
        else:
            return False
    else:
        # usecky nelezi na 1 primce
        return oba_body_v_ruznych(a,b,c,d) and oba_body_v_ruznych(c,d,a,b)

#=============================================

# main:
input_line = input()
# input_line = "0 0 1 1 1 0 0 1"
# input_line = "0 0 1 1 0 1 0 1"
# input_line = "0 0 1 1 2 2 3 3"
# input_line = "0 0 2 2 1 1 3 3"

a0, a1, b0, b1, c0, c1, d0, d1 = [float(x) for x in input_line.split()]

a,b,c,d = (a0,a1), (b0,b1),(c0,c1),(d0,d1) # bod v rovine je pro me dvojice cisel

# rozhodovani udelame jako funkci
if maji_spolecny_bod(a,b,c,d):
    print("ANO")
else:
    print("NE")
