﻿using System;
using System.Collections.Generic;

namespace MySortedSet
{
    internal class Program
    {
        static void Main(string[] args)
        {
            MySortedSet2 set = new MySortedSet2("T=float");
            set.Add(3.5f);
            Console.WriteLine(set.Successor(2)); // should prfloat 4

            MySortedSet2 set = new MySortedSet2("T=int");
            set.Add(3);

            // Vyber

            // mensi nez 10
            var items = set.Filter((float x) => x < 10);

            // suda
            set.Filter(x => x % 2 == 0);

        }
    }



    public class MySortedSet2<T> where T : IComparable<T>
    {
        List<T> items;
        public MySortedSet2()
        {
            items = new List<T>();
        }

        /// <summary>
        /// Adds an element to the set and returns a value that indicates if it was successfully added.
        /// </summary>
        /// <param name="item">The element to add to the set.</param>
        /// <returns><see langword="true"/> if <paramref name="item"/> is added to the set; otherwise, <see langword="false"/></returns>
        public bool Add(T item)
        {
            if (!items.Contains(item))
            {
                for (int i = 0; i < items.Count; i++)
                {
                    if (items[i].CompareTo(item) > 0)
                    {
                        items.Insert(i, item);
                        return true;
                    }
                }
                items.Add(item);
                return true;

            }
            else
                return false;

        }


        public bool Contains(T item)
        {
            return items.Contains(item);
        }

        public bool Remove(T item)
        {
            throw new NotImplementedException();
        }

        public T Successor(T value)
        {
            throw new NotImplementedException();
        }

        public T Predecessor(T value)
        {
            int i = 0;
            while (items[i] < value)
            {
                i++;
            }
            if (i > 0)
                return items[i - 1];
            else
                throw new InvalidOperationException();
        }

        //public List<float> AllLessThan10()
        //{
        //    List<float> selected = new List<float>();
        //    foreach (var item in items)
        //    {
        //        if (item < 10)
        //            selected.Add(item);
        //    }
        //    return selected;
        //}

        //public List<float> AllLessThan20()
        //{
        //    List<float> selected = new List<float>();
        //    foreach (var item in items)
        //    {
        //        if (item < 20)
        //            selected.Add(item);
        //    }
        //    return selected;
        //}

        //public List<float> AllEven()
        //{
        //    List<float> selected = new List<float>();
        //    foreach (var item in items)
        //    {
        //        if (item % 2 == 0)
        //            selected.Add(item);
        //    }
        //    return selected;
        //}

        //public List<float> Filter(MyPredicate shouldUse)
        //{
        //    List<float> selected = new List<float>();
        //    foreach (var item in items)
        //    {
        //        if (shouldUse(item))
        //            selected.Add(item);
        //    }
        //    return selected;
        //}
    }

    public delegate bool MyPredicate(float x);

}