﻿using System;
using System.Collections.Generic;

namespace MySortedSet
{
    internal class Program
    {
        static void Main(string[] args)
        {
            MySortedSet set = new MySortedSet();
            set.Add(3);
            set.Add(4);
            set.Add(1);
            set.Add(3);
            set.Add(2);
            set.Add(3);
            set.Remove(3);
            Console.WriteLine(set.Successor(2)); // should print 4

            // Vyber

            // mensi nez 10
            var items = set.Filter((int x) => x < 10);
            
            // suda
            set.Filter(x => x%2==0);

            set.Filter(x => x + "0" );
        }
    }


    public class MySortedSet
    {
        List<int> items;
        public MySortedSet()
        {
            items = new List<int>();
        }

        /// <summary>
        /// Adds an element to the set and returns a value that indicates if it was successfully added.
        /// </summary>
        /// <param name="item">The element to add to the set.</param>
        /// <returns><see langword="true"/> if <paramref name="item"/> is added to the set; otherwise, <see langword="false"/></returns>
        public bool Add(int item)
        {
            if (!items.Contains(item))
            {
                for (int i = 0; i < items.Count; i++)
                {
                    if (items[i] > item)
                    {
                        items.Insert(i,item);
                        return true;
                    }
                }
                items.Add(item);
                return true;
                
            }
            else
                return false;
            
        }


        public bool Contains(int item)
        {
            return items.Contains(item);
        }

        public bool Remove(int item)
        {
            throw new NotImplementedException();
        }

        public int Successor(int value)
        {
            throw new NotImplementedException();
        }

        public int Predecessor(int value)
        {
            int i = 0;
            while (items[i] < value)
            {
                i++;
            }
            if (i > 0)
                return items[i - 1];
            else
                throw new InvalidOperationException();
        }

        public List<int> AllLessThan10()
        {
            List<int> selected = new List<int>();
            foreach (var item in items)
            {
                if (item < 10)
                    selected.Add(item);
            }
            return selected;
        }

        public List<int> AllLessThan20()
        {
            List<int> selected = new List<int>();
            foreach (var item in items)
            {
                if (item < 20)
                    selected.Add(item);
            }
            return selected;
        }

        public List<int> AllEven()
        {
            List<int> selected = new List<int>();
            foreach (var item in items)
            {
                if (item % 2 == 0)
                    selected.Add(item);
            }
            return selected;
        }

        public List<int> Filter(MyPredicate shouldUse)
        {
            List<int> selected = new List<int>();
            foreach (var item in items)
            {
                if (shouldUse(item))
                    selected.Add(item);
            }
            return selected;
        }
    }

    public delegate bool MyPredicate(int x);

}