﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using MySortedSet;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MySortedSet.Tests
{
    [TestClass()]
    public class MySortedSetTests
    {


        [TestMethod()]
        public void AddTest()
        {
            // Arrange
            MySortedSet mySortedSet = new MySortedSet();

            // Act
            bool result = mySortedSet.Add(5);

            // Assert
            Assert.IsTrue(result && mySortedSet.Contains(5));
        }

        [TestMethod()]
        public void AddTest2()
        {
            // Arrange
            MySortedSet mySortedSet = new MySortedSet();
            mySortedSet.Add(5);

            // Act
            bool result = mySortedSet.Add(5);

            // Assert
            Assert.IsTrue(!result && mySortedSet.Contains(5));
        }

        [TestMethod()]
        public void ContainsTest()
        {
            Assert.Fail();
        }

        [TestMethod()]
        public void RemoveTest()
        {
            Assert.Fail();
        }

        [TestMethod()]
        public void SuccessorTest()
        {
            Assert.Fail();
        }

        [TestMethod()]
        public void PredecessorTest()
        {
            // Arrange
            MySortedSet mySortedSet = new MySortedSet();
            mySortedSet.Add(5);
            mySortedSet.Add(8);
            mySortedSet.Add(9);

            // Act
            int p = mySortedSet.Predecessor(8);

            // Assert
            Assert.AreEqual(5,p);
        }

        [TestMethod()]
        public void PredecessorTest2()
        {
            // Arrange
            MySortedSet mySortedSet = new MySortedSet();
            mySortedSet.Add(5);
            mySortedSet.Add(8);
            mySortedSet.Add(9);


            // Act Assert
            Assert.ThrowsException<InvalidOperationException>(
                ()=>mySortedSet.Predecessor(5)
                );
        }
    }
}