﻿using SkiaSharp;

namespace GeomConstructions
{
    internal class Program
    {
        static void Main(string[] args)
        {

     

            Drawer drawer = new Drawer();


            string line;
            while((line = Console.ReadLine()) != "")
            {
                string[] tokens = line.Split();
                switch (tokens[0])
                {
                    case "Point":
                        drawer.DrawPoint(tokens[1], int.Parse(tokens[2]), int.Parse(tokens[3]));
                        break;
                    case "Line":
                        drawer.DrawLine(tokens[1], tokens[2]);
                        break;
                    case "Save":
                        drawer.Save();
                        break;
                    case "Style":
                        drawer.SetStyle(tokens[1], int.Parse(tokens[2]));
                        break;
                    case "AddLogo":
                        drawer.AddLogo();
                        break;
                    default:
                        Console.WriteLine("Unknown command");
                        break;
                }
            }

            //// kresli bod
            //drawer.DrawPoint("A", 10, 10);
            //drawer.DrawPoint("B", 50, 50);

            //drawer.DrawLine("A", "B");

            //// Ulozeni obrazku
            //drawer.Save();

            /**
Point A 10 10
Point B 50 50

Line A B
Save
            */
        }

        class Drawer
        {
            SKSurface surface;
            SKCanvas canvas;
            SKPaint paint;

            Dictionary<string, (int, int)> pointCoordinates;

            public Drawer()
            {
                SKImageInfo info = new SKImageInfo(200, 200);
                surface = SKSurface.Create(info);

                canvas = surface.Canvas;
                canvas.Clear(SKColors.White);

                paint = new SKPaint();

                pointCoordinates = new();
            }

            public void DrawPoint(string label, int x, int y)
            {
                pointCoordinates.Add(label, (x, y));
                canvas.DrawCircle(x, y, 5, paint);
                canvas.DrawText(label, x+10, y, paint);
            }

            public void DrawLine(string point1, string point2)
            {
                (int x1, int y1) = pointCoordinates[point1];
                (int x2, int y2) = pointCoordinates[point2];
                canvas.DrawLine(x1, y1, x2, y2, paint);
            }

            public void Save()
            {
                using (SKImage image = surface.Snapshot())
                using (SKData data = image.Encode())
                using (FileStream stream = File.OpenWrite("1.png"))
                {
                    data.SaveTo(stream);
                }
            }

            internal void SetStyle(string color, int brushWidth)
            {
                paint.Color = SKColor.Parse(color);
                paint.StrokeWidth = brushWidth;
            }

            internal void AddLogo()
            {
                using (var image = SKImage.FromEncodedData("logo.bmp"))
                    canvas.DrawImage(image, 200 - image.Width, 200 - image.Height);
            }
        }
    }
}
